<?php
/**
 * Password Reset Request API
 * POST /api/members/forgot-password.php
 */

require_once '../../config/database.php';
require_once '../../includes/cors.php';
require_once '../../includes/helpers.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents("php://input"), true);

if (empty($data['email'])) {
    jsonResponse(['success' => false, 'message' => 'Email is required'], 400);
}

$email = sanitizeInput($data['email']);

if (!isValidEmail($email)) {
    jsonResponse(['success' => false, 'message' => 'Invalid email format'], 400);
}

try {
    $database = new Database();
    $db = $database->getConnection();

    // Check if email exists
    $stmt = $db->prepare("SELECT id, full_name FROM members WHERE email = ?");
    $stmt->execute([$email]);
    $member = $stmt->fetch();

    // Always return success to prevent email enumeration
    if (!$member) {
        jsonResponse([
            'success' => true,
            'message' => 'If an account with this email exists, you will receive a password reset link.'
        ]);
    }

    // Generate reset token
    $resetToken = bin2hex(random_bytes(32));
    $expiry = date('Y-m-d H:i:s', strtotime('+1 hour'));

    // Store token (you might want to create a password_resets table)
    // For now, we'll just return success
    // In production, you would send an email with the reset link

    jsonResponse([
        'success' => true,
        'message' => 'If an account with this email exists, you will receive a password reset link.',
        // In development, you can return the token for testing
        // 'debug_token' => $resetToken
    ]);

} catch (PDOException $e) {
    jsonResponse(['success' => false, 'message' => 'Request failed'], 500);
}
?>
