<?php
/**
 * Admin - Approve/Reject Member API
 * PUT /api/admin/members/approve.php
 */

require_once '../../../config/database.php';
require_once '../../../includes/cors.php';
require_once '../../../includes/helpers.php';
require_once '../../../includes/jwt.php';

if ($_SERVER['REQUEST_METHOD'] !== 'PUT') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

// Authenticate admin
$jwt = new JWTHandler();
$userData = $jwt->authenticateAdmin();

$data = json_decode(file_get_contents("php://input"), true);

if (empty($data['member_id'])) {
    jsonResponse(['success' => false, 'message' => 'Member ID is required'], 400);
}

if (empty($data['action']) || !in_array($data['action'], ['approve', 'reject', 'suspend'])) {
    jsonResponse(['success' => false, 'message' => 'Valid action (approve, reject, suspend) is required'], 400);
}

$memberId = intval($data['member_id']);
$action = $data['action'];

try {
    $database = new Database();
    $db = $database->getConnection();

    // Check if member exists
    $stmt = $db->prepare("SELECT * FROM members WHERE id = ?");
    $stmt->execute([$memberId]);
    $member = $stmt->fetch();

    if (!$member) {
        jsonResponse(['success' => false, 'message' => 'Member not found'], 404);
    }

    // Determine new status
    $newStatus = '';
    switch ($action) {
        case 'approve':
            if ($member['status'] !== 'pending') {
                jsonResponse(['success' => false, 'message' => 'Only pending members can be approved'], 400);
            }
            $newStatus = 'approved';
            break;
        case 'reject':
            if ($member['status'] !== 'pending') {
                jsonResponse(['success' => false, 'message' => 'Only pending members can be rejected'], 400);
            }
            $newStatus = 'rejected';
            break;
        case 'suspend':
            if ($member['status'] !== 'approved') {
                jsonResponse(['success' => false, 'message' => 'Only approved members can be suspended'], 400);
            }
            $newStatus = 'suspended';
            break;
    }

    // Update member status
    $stmt = $db->prepare("
        UPDATE members 
        SET status = ?, approved_by = ?, approved_at = NOW()
        WHERE id = ?
    ");
    $stmt->execute([$newStatus, $userData['user_id'], $memberId]);

    jsonResponse([
        'success' => true,
        'message' => "Member has been {$action}d successfully",
        'data' => [
            'member_id' => $member['member_id'],
            'full_name' => $member['full_name'],
            'new_status' => $newStatus
        ]
    ]);

} catch (PDOException $e) {
    jsonResponse(['success' => false, 'message' => 'Action failed: ' . $e->getMessage()], 500);
}
?>
