<?php
/**
 * Admin Login API
 * POST /api/admin/login.php
 */

require_once '../../config/database.php';
require_once '../../includes/cors.php';
require_once '../../includes/helpers.php';
require_once '../../includes/jwt.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$data = json_decode(file_get_contents("php://input"), true);

if (empty($data['email']) || empty($data['password'])) {
    jsonResponse(['success' => false, 'message' => 'Email and password are required'], 400);
}

$email = sanitizeInput($data['email']);
$password = $data['password'];

try {
    $database = new Database();
    $db = $database->getConnection();

    $stmt = $db->prepare("SELECT * FROM admins WHERE email = ?");
    $stmt->execute([$email]);
    $admin = $stmt->fetch();

    if (!$admin) {
        jsonResponse(['success' => false, 'message' => 'Invalid email or password'], 401);
    }

    if (!password_verify($password, $admin['password'])) {
        jsonResponse(['success' => false, 'message' => 'Invalid email or password'], 401);
    }

    // Generate JWT token
    $jwt = new JWTHandler();
    $token = $jwt->generateToken($admin['id'], $admin['email'], $admin['role']);

    jsonResponse([
        'success' => true,
        'message' => 'Login successful',
        'data' => [
            'token' => $token,
            'admin' => [
                'id' => $admin['id'],
                'username' => $admin['username'],
                'full_name' => $admin['full_name'],
                'email' => $admin['email'],
                'role' => $admin['role']
            ]
        ]
    ]);

} catch (PDOException $e) {
    jsonResponse(['success' => false, 'message' => 'Login failed: ' . $e->getMessage()], 500);
}
?>
