# ANILAD Cooperative Backend

PHP backend with MySQL database for the ANILAD Cooperative application.

## Setup Instructions

### 1. Database Setup

1. Start your MySQL server (XAMPP, WAMP, or standalone MySQL)
2. Create the database by running the SQL schema:
   - Open phpMyAdmin or MySQL CLI
   - Run the contents of `database/schema.sql`

### 2. Configure Database Connection

Edit `config/database.php` and update the following constants:

```php
define('DB_HOST', 'localhost');     // Your MySQL host
define('DB_NAME', 'anilad_coop');   // Database name
define('DB_USER', 'root');          // MySQL username
define('DB_PASS', '');              // MySQL password
```

### 3. Set Up Web Server

#### Using XAMPP/WAMP:
1. Copy the `backend` folder to your web server's document root:
   - XAMPP: `C:\xampp\htdocs\anilad-coop\backend`
   - WAMP: `C:\wamp64\www\anilad-coop\backend`

2. Update the `API_BASE_URL` in `services/apiService.ts` to match your setup:
   ```typescript
   const API_BASE_URL = 'http://localhost/anilad-coop/backend/api';
   ```

### 4. Default Admin Credentials

After setting up the database, you can log in as admin with:
- **Email:** admin@aniladcoop.com
- **Password:** password

⚠️ **Important:** Change this password immediately in production!

## API Endpoints

### Member Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/api/members/register.php` | Register new member |
| POST | `/api/members/login.php` | Member login |
| GET | `/api/members/profile.php` | Get member profile (requires auth) |
| POST | `/api/members/forgot-password.php` | Request password reset |

### Loan Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/api/loans/apply.php` | Apply for loan (requires auth) |
| GET | `/api/loans/list.php` | Get member's loans (requires auth) |

### Transaction Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/api/transactions/list.php` | Get member transactions (requires auth) |
| POST | `/api/deposits/process.php` | Process deposit to virtual account |

### Admin Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/api/admin/login.php` | Admin login |
| GET | `/api/admin/dashboard.php` | Get dashboard statistics |
| GET | `/api/admin/members/list.php` | List all members |
| PUT | `/api/admin/members/approve.php` | Approve/reject/suspend member |
| GET | `/api/admin/loans/list.php` | List all loans |
| PUT | `/api/admin/loans/approve.php` | Approve/reject loan |
| PUT | `/api/admin/loans/disburse.php` | Disburse approved loan |
| GET | `/api/admin/transactions/list.php` | List all transactions |
| POST | `/api/admin/deposits/record.php` | Record manual deposit |

## Business Rules

### Member Registration
- All fields are required except next of kin email
- Account starts in `pending` status
- Virtual account is created automatically
- Account must be approved by admin before member can log in

### Loan Eligibility
- Member must be active for at least **6 months**
- Maximum loan amount: **200% of savings balance**
- Cannot have an active loan (pending, approved, disbursed, or repaying)

### Loan Terms
| Duration | Interest Rate |
|----------|---------------|
| 3 months | 3% |
| 6 months | 5% |
| 12 months | 10% |

### Deposit Processing
When money is deposited to a virtual account:
1. First, check for active loans
2. If loan exists, repay loan first
3. Remaining amount goes to savings

### Guarantors
- Every loan application requires **exactly 3 guarantors**
- Each guarantor must have name and phone number

## File Structure

```
backend/
├── api/
│   ├── admin/
│   │   ├── dashboard.php
│   │   ├── login.php
│   │   ├── deposits/
│   │   │   └── record.php
│   │   ├── loans/
│   │   │   ├── approve.php
│   │   │   ├── disburse.php
│   │   │   └── list.php
│   │   ├── members/
│   │   │   ├── approve.php
│   │   │   └── list.php
│   │   └── transactions/
│   │       └── list.php
│   ├── deposits/
│   │   └── process.php
│   ├── loans/
│   │   ├── apply.php
│   │   └── list.php
│   ├── members/
│   │   ├── forgot-password.php
│   │   ├── login.php
│   │   ├── profile.php
│   │   └── register.php
│   └── transactions/
│       └── list.php
├── config/
│   └── database.php
├── database/
│   └── schema.sql
├── includes/
│   ├── cors.php
│   ├── helpers.php
│   └── jwt.php
└── README.md
```

## Security Notes

1. Change the JWT secret key in `includes/jwt.php` for production
2. Use HTTPS in production
3. Implement rate limiting
4. Add input validation for all endpoints
5. Use prepared statements (already implemented)
6. Hash passwords using bcrypt (already implemented)
